/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.overlays.v2_1;

import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.datamodels.v2_1.DataModelConstants;
import com.roguewave.chart.drawables.device.v2_1.DeviceLines;
import com.roguewave.chart.overlay.core.v2_1.ChartOverlay;
import com.roguewave.chart.overlay.core.v2_1.ParameterCalculator;
import com.roguewave.chart.overlay.core.v2_1.ScaleConstants;
import com.roguewave.chart.overlay.core.v2_1.Scaler;
import com.roguewave.chart.overlay.overlays.v2_1.StockConstants;
import java.awt.Color;

public class HighLowChartOverlay
implements ChartOverlay,
DataModelConstants,
StockConstants,
ScaleConstants {
    int tickWidth_;
    Color color_;
    boolean scale_;

    public HighLowChartOverlay(int tickWidth, Color color, boolean scale) {
        this.tickWidth_ = this.tickWidth_ < 0 ? 2 : tickWidth;
        this.color_ = color;
        this.scale_ = scale;
    }

    public int getItemWidth() {
        return 1 + 2 * this.tickWidth_;
    }

    public void addTo(ChartGraphics chartGraphics, DataModel data, int base, int left, int right, int offset, int columnWidth, ParameterCalculator params1, ParameterCalculator params2) {
        Scaler scaler = this.scale_ ? params1.getScaler() : params2.getScaler();
        int dataPoints = data.getColumnCount();
        int xi = left + offset;
        int[] x = new int[dataPoints];
        int[] y1 = new int[dataPoints];
        int[] y2 = new int[dataPoints];
        int[] tx1 = new int[dataPoints * 2];
        int[] tx2 = new int[dataPoints * 2];
        int[] ty = new int[dataPoints * 2];
        int tIndex = 0;
        int index = 0;
        for (int i = 0; i < dataPoints; ++i) {
            double rawClose = data.getValue(0, i);
            double rawOpen = data.getValue(1, i);
            double rawHigh = data.getValue(2, i);
            double rawLow = data.getValue(3, i);
            if (rawClose == Double.NEGATIVE_INFINITY || rawOpen == Double.NEGATIVE_INFINITY || rawHigh == Double.NEGATIVE_INFINITY || rawLow == Double.NEGATIVE_INFINITY) {
                ty[tIndex] = -10000;
                tx2[tIndex] = -10000;
                tx1[tIndex] = -10000;
                ty[++tIndex] = -10000;
                tx2[tIndex] = -10000;
                tx1[tIndex] = -10000;
                ++tIndex;
                y2[index] = -10000;
                y1[index] = -10000;
                x[index] = -10000;
                ++index;
            } else {
                int close = scaler.scale(rawClose);
                int open = scaler.scale(rawOpen);
                int high = scaler.scale(rawHigh);
                int low = scaler.scale(rawLow);
                tx1[tIndex] = xi - this.tickWidth_;
                tx2[tIndex] = xi;
                ty[tIndex++] = base - open;
                x[index] = xi;
                y1[index] = base - low;
                y2[index] = base - high;
                ++index;
                tx2[tIndex] = xi;
                tx1[tIndex] = xi + this.tickWidth_;
                ty[tIndex++] = base - close;
            }
            xi += columnWidth;
        }
        chartGraphics.add2DDrawable(new DeviceLines(tx1, ty, tx2, ty, this.color_));
        chartGraphics.add2DDrawable(new DeviceLines(x, y1, x, y2, this.color_));
    }

    public Color getColor() {
        return this.color_;
    }

    public void setColor(Color color) {
        this.color_ = color;
    }

    public boolean getScale() {
        return this.scale_;
    }

    public void setScale(boolean scale) {
        this.scale_ = scale;
    }

    public int getTickWidth() {
        return this.tickWidth_;
    }

    public void setTickWidth(int width) {
        if (width >= 0) {
            this.tickWidth_ = width;
        }
    }
}

